/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block.crops;

import com.renyigesai.immortalers_delight.block.ReapCropBlock;
import com.renyigesai.immortalers_delight.client.particle.SnowFogParticleOption;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class GelpitayaCropBlock
extends ReapCropBlock {
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] COLLISION_SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)10.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0)};

    public GelpitayaCropBlock(BlockBehaviour.Properties p_52247_) {
        super(p_52247_);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return COLLISION_SHAPE_BY_AGE[(Integer)pState.m_61143_((Property)f_52244_)];
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[(Integer)pState.m_61143_((Property)f_52244_)];
    }

    protected ItemLike m_6404_() {
        return (ItemLike)ImmortalersDelightItems.GELPITAYA_SEEDS.get();
    }

    @Override
    public boolean canReap(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41735_(state)) {
            boolean flag = super.canReap(state, level, pos, player, hand, hitResult);
            if (flag && !player.m_150110_().f_35937_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                itemStack.m_41622_(1, (LivingEntity)serverPlayer, action -> action.m_21190_(hand));
            }
            return flag;
        }
        return false;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate = pLevel.m_8055_(pPos.m_121945_(direction));
            if (!blockstate.m_280296_() && !pLevel.m_6425_(pPos.m_121945_(direction)).m_205070_(FluidTags.f_13132_)) continue;
            return false;
        }
        BlockState blockstate1 = pLevel.m_8055_(pPos.m_7495_());
        return blockstate1.m_60734_() instanceof CactusBlock && !pLevel.m_8055_(pPos.m_7494_()).m_278721_();
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_60734_() instanceof CactusBlock;
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        int i = this.m_52305_(pState);
        if (i >= 3) {
            pEntity.m_6469_(pLevel.m_269111_().m_269325_(), 1.0f);
        }
        if (i >= 5) {
            pEntity.m_146924_(true);
            if (!pLevel.f_46443_) {
                pEntity.m_146868_(false);
            }
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        float f;
        int i;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 9 && (i = this.m_52305_(pState)) < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / (f = GelpitayaCropBlock.m_52272_((Block)this, (BlockGetter)pLevel, (BlockPos)pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            if (i == this.m_7419_() - 1) {
                this.spawnParticle((Level)pLevel, pPos);
                this.spawnSnow((Level)pLevel, pPos, 1, 3, 1);
            }
            pLevel.m_7731_(pPos, this.m_52289_(i + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public void spawnSnow(Level pLevel, BlockPos pPos, int x, int y, int z) {
        for (int i = -x; i <= x; ++i) {
            for (int j = -y; j <= y; ++j) {
                for (int k = -z; k <= z; ++k) {
                    if (i == 0 && j <= 0 && k == 0) continue;
                    BlockPos blockPos = pPos.m_7918_(i, j, k);
                    BlockPos belowPos = blockPos.m_7495_();
                    BlockState blockState = pLevel.m_8055_(blockPos);
                    BlockState belowState = pLevel.m_8055_(belowPos);
                    if (blockState.m_60795_() && GelpitayaCropBlock.m_49918_((VoxelShape)belowState.m_60812_((BlockGetter)pLevel, belowPos), (Direction)Direction.UP)) {
                        pLevel.m_46597_(blockPos, Blocks.f_50125_.m_49966_());
                        continue;
                    }
                    if (blockState.m_60713_(Blocks.f_50450_)) {
                        pLevel.m_46597_(blockPos, Blocks.f_50134_.m_49966_());
                        continue;
                    }
                    if (blockState.m_60713_(Blocks.f_50125_)) {
                        int layer = (Integer)pLevel.m_8055_(blockPos).m_61143_((Property)SnowLayerBlock.f_56581_);
                        if (layer >= 8) continue;
                        pLevel.m_7731_(blockPos, (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layer + 1)), 2);
                        continue;
                    }
                    if (!blockState.m_60713_(Blocks.f_49990_)) continue;
                    pLevel.m_46597_(blockPos, Blocks.f_50126_.m_49966_());
                }
            }
        }
    }

    private void spawnParticle(Level level, BlockPos pPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5);
            double radius = 2.0;
            for (int i = 0; i < 32; ++i) {
                double angle = Math.PI * 2 * Math.random();
                double r = radius * Math.sqrt(Math.random());
                double x = center.f_82479_ + r * Math.cos(angle);
                double z = center.f_82481_ + r * Math.sin(angle);
                double y = center.f_82480_ + r;
                if ((double)i % radius == 0.0) {
                    SnowFogParticleOption particleOption = new SnowFogParticleOption((int)radius);
                    serverLevel.m_8767_((ParticleOptions)particleOption, center.f_82479_, y, center.f_82481_, 1, 0.0, 0.0, 0.0, 0.025);
                    continue;
                }
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 5, 0.25, 0.25, 0.25, 0.025);
            }
        }
    }

    public void m_52263_(Level pLevel, BlockPos pPos, BlockState pState) {
        int i = this.m_52305_(pState) + this.m_7125_(pLevel);
        int j = this.m_7419_();
        if (this.m_52305_(pState) == j - 1) {
            i = j;
            this.spawnParticle(pLevel, pPos);
            this.spawnSnow(pLevel, pPos, 1, 3, 1);
        } else if (i >= j) {
            i = j - 1;
        }
        pLevel.m_7731_(pPos, this.m_52289_(i), 2);
    }

    public int m_7419_() {
        return 6;
    }
}

